<?php

############################################################ Property page #############################################################

if(isset($_GET['p'],$_GET['pn']))

{

	$_GET['p'] = (int)preg_replace('/\D/', '', $_GET['p']);

	try

	{

		$q = $pdo->prepare("SELECT * FROM properties,agents,owners WHERE property_tracking = ? and agent_id = property_agent and owner_id = property_detail_owner");

		$q ->bindParam(1, $_GET['p'], PDO::PARAM_INT);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'; exit();}

	$p = $q->fetch(PDO::FETCH_ASSOC);

		

	if($q->rowCount() != 1) {$_SESSION['error'] = 'Your Property ID is wrong. Please try again or contact us.'; r();}

	

	$p['property_detail_address'] = '';

	if($p['property_detail_city'] != '')

	{

		$p['property_detail_address'] .= $p['property_detail_city'];

		if($p['property_detail_post_code'] != '')

		{

			$p['property_detail_address'] .= ' '.$p['property_detail_post_code'];

		}

	}

	elseif($p['property_detail_post_code'] != '')

	{

		$p['property_detail_address'] .= $p['property_detail_post_code'];

	}

	if($p['property_detail_street'] != '')

	{

		if($p['property_detail_address'] != '')

		{

			$p['property_detail_address'] .= ', ';

		}

		$p['property_detail_address'] .= $p['property_detail_street'];

		if($p['property_detail_street_nr'] != '')

		{

			$p['property_detail_address'] .= ' '.$p['property_detail_street_nr'];

		}

	}



	echo '<table cellspacing="0" cellpadding="0" id="product">';

		echo '<tr>';

			echo '<td valign="top">';

				echo '<div class="title"><h1>';

				if($p['property_status'] == 'sold')

				{

					echo '<img src="/f/sold-icon.png" />';

				}

				echo $p['property_name'].'</h1></div>';

				echo '<div class="bar">';

					echo '<a href="javascript:window.print()"><img src="/f/print.png" />Print this page</a>';

					$some_details = '';

					if(!empty($p['property_detail_size'])) {$some_details .= str_replace('.00','',$p['property_detail_size']).' Square meters, ';}

					if(!empty($p['property_detail_bedrooms'])) {$some_details .= $p['property_detail_bedrooms'].' Beds, ';}

					if(!empty($p['property_detail_bathrooms'])) {$some_details .= $p['property_detail_bathrooms'].' Baths, ';}

					if(!empty($p['property_detail_rooms'])) {$some_details .= $p['property_detail_rooms'].' Rooms, ';}

					echo substr($some_details,0,-2);

				echo '</div>';

				

				$exist = 0;

				echo '<div class="galery">';

					foreach(range(1,100) as $i)

					{

						$img = 'p/'.$p['property_id'].'_'.$i.'.png';

						if(file_exists($img))

						{

							$exist++;

							if(!isset($big))

							{

								echo '<div class="big none"><div style="background:url('.$img.') no-repeat center center;"></div></div>';

								$big = 'true';

							}

							

							echo '<div class="thumb thumb_'.$exist.'"'; if($exist > 6 ) {echo ' style="display:none;"';} echo ' onclick="'."$('.big div').css('background','url($img) center center')".'"><div style="background:url('.$img.') no-repeat center center;"></div><span>Loading...</span></div>';

						}

					}

					echo '<input type="hidden" name="property_images" value="'.$exist.'" />';

					echo '<input type="hidden" name="property_images_page" value="1" />';

					echo '<div class="slide-buttons">';

					echo '<span onclick="slider('."'back'".')" class="opacity no-select"><img src="/f/slide-back.png" /></span>';

					echo '<span onclick="slider('."'next'".')"'; if($exist < 7) {echo ' class="opacity no-select"';} else { echo ' class="no-select"';} echo '><img src="/f/slide-next.png" /></span>';

					echo '</div>';

				echo '</div>';

					

				echo '<div class="title" style="border-top:0px;"><h1>Property Features - '.$p['property_name'].'</h1></div>';

				

				echo '<div class="features">';

					$details = array('property_detail_address','property_price','property_rent','property_detail_owner','property_detail_size','property_detail_floor','property_detail_floors','property_detail_rooms','property_detail_bedrooms','property_detail_bathrooms','property_detail_year_built','property_detail_balcony_terrace','property_detail_basement','property_detail_garden','property_detail_furniture','property_detail_elevator','property_detail_garage');

					$i = 0;

					foreach($details as $detail)

					{

						if(!empty($p[$detail]))

						{

							if($detail == 'property_detail_owner')

							{

								$p['owner'] = unserialize($p['owner']);

								$owner = $p['owner']['passport_first_name'].' '.@$p['owner']['passport_second_name'].' '.substr($p['owner']['passport_last_name'],0,1).'.';

								$p[$detail] = $owner;

							}

							elseif($detail == 'property_detail_size')

							{

								$p[$detail] = $p[$detail].' m<sup>2</sup>';

							}

							if($detail == 'property_detail_address' && mb_strlen($p[$detail],'UTF-8') > 35)

							{

								$i++;

								echo '<span class="address r5" onmouseout="'."$('span.address').hide();".'">'.$p[$detail].'</span>';

								echo '<p onmouseover="'."$('span.address').show();".'"'; if($i % 2) {echo ' class="border"'; $border = 'true';} else {$border = 'false';} echo '>'.ucfirst(str_replace('_',' ',str_replace('property_detail_','',$detail))).' :<span class="ellipsis">'.$p[$detail].'</span></p>';

								$big_address = 'true';

							}

							elseif($detail == 'property_price' && $p['property_type'] == 0)

							{

								$i++;

								echo '<p'; if($i % 2) {echo ' class="border"'; $border = 'true';} else {$border = 'false';} echo '>'.ucfirst(str_replace('_',' ',str_replace('property_detail_','',$detail))).' :<span>'.$p[$detail].'</span></p>';

							}

							elseif($detail == 'property_rent' && $p['property_type'] == 1)

							{

								$i++;

								echo '<p'; if($i % 2) {echo ' class="border"'; $border = 'true';} else {$border = 'false';} echo '>Rent / Month:<span>'.$p[$detail].'</span></p>';

							}

							elseif($detail != 'property_price' && $detail != 'property_rent')

							{

								$i++;

								echo '<p'; if(isset($big_address)) {echo ' onmouseover="'."$('span.address').hide();".'"';} if($i % 2) {echo ' class="border"'; $border = 'true';} else {$border = 'false';} echo '>'.ucfirst(str_replace('terrace','/ Terrace',str_replace('_',' ',str_replace('property_detail_','',$detail)))).' :<span>'.$p[$detail].'</span></p>';

							}

						}

					}

					if($p['property_type'] == 0)

					{

						echo '<p'; if($border == 'true') {echo ' class="border"';} else { echo ' class="big"'; } echo '>Earnest Money Deposit : <span>';

						if($p['property_detail_earnest_procent'] != 0)

						{

							echo $p['property_detail_earnest_procent'].'% - ';

						}

						echo $p['property_detail_earnest_deposit'].' &euro;</span></p>';

					}

					else

					{

						echo '<p'; if($border == 'true') {echo ' class="border"';} else { echo ' class="big"'; } echo '>Deposit : <span>'.$p['property_deposit'].'</span></p>';

					}

				echo '</div>';

				

				if(str_replace(' ','',$p['property_description']) != '')

				{

					echo '<div class="p20 property_description">'.$p['property_description'].'</div>';

				}

				

				if(str_replace(' ','',$p['property_furnishing']) != '')

				{

					echo '<div class="p20 property_description">'.nl2br($p['property_furnishing']).'</div>';

				}

				

				if(str_replace(' ','',$p['property_location']) != '')

				{

					echo '<div class="p20 property_description">'.nl2br($p['property_location']).'</div>';

				}

				

				foreach(range(1,100) as $i)

				{

					$img = 'p/'.$p['property_id'].'_floor_'.$i.'.png';

					if(file_exists($img))

					{

						$floor[$i] = $img;

					}

				}

				

				if(isset($floor))

				{

					$count_plans = count($floor);

					echo '<div class="title" style="border-top:0px;"><h1>Floor Plan'; if($count_plans > 1) {echo 's';} echo '</h1></div>';

					

					echo '<div class="floor-plan p20">';

						foreach($floor as $plan)

						{

							echo '<p style="width:';

							if($count_plans == 1)

							{

								echo '97';

							}

							else

							{

								echo ((100 / $count_plans) - $count_plans).'%; margin:0px '.($count_plans / 2);

							}

							echo '%;background:url('.$plan.') no-repeat center bottom; background-size:auto 90%;">

							<a href="/'.$plan.'?#'.$_GET['p'].'" target="_blank"><img src="f/view.png" />View in new window</a></p>';

						}

					echo '</div>';

				}

				if(str_replace(' ','',$p['property_map']) != '' && $domain != 'localhost')

				{

					echo '<div class="title" style="border-top:0px;"><h1>Property Map</h1></div>';

					echo str_replace('<a ','<a style="display:none" ',$p['property_map']);

				}

					

				echo '<a href="/fair-housing" class="fair-housing"><img src="../../f/fair-housing.png" />An Equal Opportunity Company</a>';

			echo '</td>';

			echo '<td class="product_right" valign="top">';

				echo '<h5><b>Contact</b> agent';

				echo '</h5>';

						

				echo '<form action="" method="post">';

					

				if($p['property_status'] == 'sold')

				{

					echo '<div class="sold" onclick="'."$('img',this).fadeToggle(100);".'"><img src="../../f/contact-sold.png" style="display:none;" /></div>';

				}

				

				echo '<div class="agent">

					<img src="'.$p['agent_image'].'" />

					<p class="agent_name">'.$p['agent_name'].'<p>

					<p>'.$s['s_website_name'].' Agent<p>

					<p class="show_email no-select" onclick="'."$('.agent_email').toggle();$('.show_email').toggle();".'"><img src="/f/email.png" />Show email address<p>

					<p class="show_email no-select none" onclick="'."$('.agent_email').toggle();$('.show_email').toggle();".'"><img src="/f/email.png" />Hide email address<p>

					<p class="agent_email none">'.str_replace(' ','.',$p['agent_name']).'@'.$domain.'<p>

					<p class="agent_email">'.str_repeat('x',strlen($p['agent_name'])).'@'.$domain.'<p>

				</div>';

					

				echo '<p>Your first name <span>*</span></p>';

				echo '<input type="text" name="pc_first_name" />';

				echo '<p>Your last name <span>*</span></p>';

				echo '<input type="text" name="pc_last_name" />';

				echo '<p class="email_field">Email <span>*</span></p>';

				echo '<input type="text" name="pc_email" />';

				echo '<p class="phone_field">Phone</p>';

				echo '<input type="text" name="pc_phone" />';

				echo '<p>Additional Comments</p>';

				echo '<textarea name="pc_comment"></textarea>';

				echo '<label style="font-weight:normal;" class="no-select"><input type="checkbox" name="pc_contact_newsletter" class="radio" />Yes, I would like to receive '.$s['s_website_name'].' emails.  &nbsp;&nbsp;</label>';

				echo '<input type="submit" name="property_contact" class="button" value="Request Details" />';

				echo '<p style="margin:5px; text-align:center; font-weight:normal; color:grey"><span>*</span> Required Fields</p>';

				echo '</form>';

					

				try

				{

					$q = $pdo->prepare("SELECT * FROM properties WHERE property_status = 'sold' ORDER by rand() LIMIT 5");

					$q ->execute();

				}

				catch (PDOException $e) {echo 'Error !'; exit();}

				

				if($q->rowCount() > 0)

				{

					echo '<h5 style="border-top:0px;"><b>Sold</b> Properties </h5>';

					while($p = $q->fetch(PDO::FETCH_ASSOC))

					{

						echo '<a href="/?p='.$p['property_tracking'].'&amp;pn='.str_replace(' ','-',$p['property_name']).'" class="n-random">';

						echo '<span class="product_name">'.$p['property_name'].'</span>';

						echo '<span class="img" style="background:url(';

						foreach(range(1,100) as $i)

						{

							$img = 'p/'.$p['property_id'].'_'.$i.'.png'; if(file_exists($img)) { echo $img; break; }

						}

						echo ') no-repeat center center; background-size: 100%  100%;"></span>';

						echo '<span class="desc">';

						if(!empty($p['property_detail_size'])) {echo $p['property_detail_size'].' Square meters<br />';}

						if(!empty($p['property_detail_bedrooms'])) {echo $p['property_detail_bedrooms'].' Bedrooms<br />';}

						if(!empty($p['property_detail_bathrooms'])) {echo $p['property_detail_bathrooms'].' Bathrooms<br />';}

						if(!empty($p['property_detail_rooms'])) {echo $p['property_detail_rooms'].' Rooms<br />';}

						echo '</span>';

						echo '</a>';

					}

				}

				echo '<br /><br /><br /><br /><br /><br />';

			echo '</td>';

		echo '</tr>';

	echo '</table>';

}



###################################################### Else, check if is a page ##########################################################

elseif(ctype_alnum(str_replace('-','',str_replace('&','',$url))))

{

	$page = str_replace('-',' ',$url);

	try

	{

		$q = $pdo->prepare("SELECT * FROM pages WHERE page_name = ? OR page_name = ?");

		$q ->bindParam(1, $url, PDO::PARAM_STR);

		$q ->bindParam(2, $page, PDO::PARAM_STR);

		$q ->execute();

	}

	catch (PDOException $e) {echo 'Error !'; exit();}

	$p = $q->fetch(PDO::FETCH_ASSOC);



	if($q->rowCount() != 1)

	{

		$_SESSION['error'] = "The page you are looking for doesn't exist !"; r('../');

	}

	

	// Replace settings

	foreach($p as $key => $null)

	{

		$p[$key] = replace_settings($p[$key]);

	}

		

	############################################################ Home page ###############################################################

	if($p['page_name'] == 'Home')

	{

		try

		{

			$q = $pdo->prepare("SELECT * FROM properties WHERE property_slide = 'Yes' AND property_status != 'hidden' ORDER BY RAND() LIMIT 5");

			$q ->execute();

		}

		catch (PDOException $e) {echo 'Error !'; exit();}

		if($q->rowCount() > 0)

		{

			echo '<div id="slider">';

			$i = 0;

			while($slide = $q->fetch(PDO::FETCH_ASSOC))

			{

				$i++;

				foreach(range(1,100) as $nr)

				{

					$img = 'p/'.$slide['property_id'].'_'.$nr.'.png'; if(file_exists($img)) { $img = $img; break; }

				}

				echo '<input type="hidden" name="input_slide_'.$i.'" value="'.$img.'" />';

							

				echo '<a href="/?p='.$slide['property_tracking'].'&amp;pn='.str_replace(' ','-',$slide['property_name']).'" class="title title_'.$i.' r3"'; if($i != 1) {echo ' style="display:none"';} echo '>'.$slide['property_name'].'</a>';



				echo '<div class="description description_'.$i.' r3'; if($i != 1) {echo ' none';} echo '">';

				$details = array('property_detail_size','property_detail_rooms','property_detail_bedrooms','property_detail_bathrooms','property_detail_year_built','property_detail_balcony_terrace','property_detail_elevator','property_detail_garage');

				foreach($details as $detail)

				{

					if(!empty($slide[$detail]))

					{

						echo '<p>'.ucfirst(str_replace('terrace','/ Terrace',str_replace('_',' ',str_replace('property_detail_','',$detail)))).'<span>'.$slide[$detail];

						if($detail == 'property_detail_size') {echo ' m<sup>2</sup>';}

						echo '</span></p>';

					}

				}

				echo '<a href="/?p='.$slide['property_tracking'].'&amp;pn='.str_replace(' ','-',$slide['property_name']).'" class="r5">Read More</a>';

				echo '</div>';

			}

				

			echo '<div class="slides">';

			foreach(range(1,$i) as $num)

			{

				echo '<span class="slides_'.$num; if($num == 1) {echo ' selected';} echo '" onclick="bgchange('.$num.')"></span>';

			}

			echo '</div>';

					

			echo '<a href="#" class="arrow-right" onclick="bgchange(this);return false" style="float:right;"></a>';

			echo '<a href="#" class="arrow-left" onclick="bgchange(this);return false"></a>';

			echo '<input type="hidden" value="" name="slider" />';

			echo '<input type="hidden" value="'.$i.'" name="slider_total" />';

			echo '</div>';

		}

				

		echo '<form action="" method="post" id="search" class="r7">';

			echo '<input type="submit" name="search-property" class="search-submit r4" value="SEARCH" />';

			echo '<input type="text" name="property-id" class="search search_first r7" onclick="'."$(this).removeAttr('style')".'" autocomplete="off" '.value('Search by Property ID number').' />';

			

			echo '<input type="submit" name="search-transaction" class="search-submit r4" value="SUBMIT" />';

			echo '<input type="text" name="transaction-id" class="search r7" onclick="'."$(this).removeAttr('style')".'" autocomplete="off" '.value('Enter your Transaction ID number').' />';

			

			echo '<img src="/f/question-mark.gif" onmouseover="'."$(this).parent('form').find('div.details').show();".'" onmouseout="'."$(this).parent('form').find('div.details').hide();".'" />';

			echo '<div class="details r4">The Transaction ID number allows you to check in real-time on a secured page the progress on your purchase.</div>';

		echo '</form>';

							

		echo '<table cellspacing="0" cellpadding="0" id="page" class="r10">';

		echo '<tr>';

		echo '<td valign="top">'.replace_settings($p['page_description_left']).'</td>';

		if(!empty($p['page_description_right']))

		{

			echo '<td valign="top">'.replace_settings($p['page_description_right']).'</td>';

		}

		echo '</tr>';

		echo '</table>';

							

		echo '<div id="index-random">';

		try

		{

			$q = $pdo->prepare("SELECT property_name, property_tracking, property_status, property_id FROM properties WHERE property_status != 'hidden' ORDER BY rand() LIMIT 5");

			$q ->execute();

		}

		catch (PDOException $e) {echo 'Error !'; exit();}

		$i = 0;

		while($pr = $q->fetch(PDO::FETCH_ASSOC))

		{

			$i++;

			echo '<a href="/?p='.$pr['property_tracking'].'&amp;pn='.str_replace(' ','-',$pr['property_name']).'">';

			echo '<span class="read-more"><b class="r4">Read more</b></span>';

			if($pr['property_status'] == 'sold') { echo '<span class="status"><img src="f/sold.png" /></span>'; }

			echo '<span class="img" style="background:url(';

			foreach(range(1,100) as $i)

			{

				$img = 'p/'.$pr['property_id'].'_'.$i.'.png'; if(file_exists($img)) { echo $img; break; }

			}

			echo ') no-repeat center center; background-size:cover;"></span>';

			echo '<span class="title">';

			if(mb_strlen($pr['property_name'],'UTF-8') > 30) {$pr['property_name'] = mb_substr($pr['property_name'],0,30,'UTF-8').'...';}

			echo $pr['property_name'];

			echo '</span>';

			echo '</a>';

		}

		echo '</div>';

	}



	############################################ Else if is not Home page or Property page #############################################

	else

	{

		if($s['s_search'] == '1')

		{

			echo '<form action="" method="post" id="page-search">';

			echo '<input type="text" name="search-text" class="search-text" '.value('Type Property ID or Transaction ID number...').' />';

			echo '<input type="submit" name="search-submit" class="search-button" value="Search" onclick="'."$('#p').show();".'" />';

			echo '</form>';

		}

		elseif(strtolower($p['page_name']) == 'customer area')

		{

			echo '<div class="r10 customer-area"></div>';

		}

		elseif($s['s_search'] == '2')

		{

			echo '<div class="center"><br /><br /><br />';

				echo '<form action="" method="post" id="page-search-medium">';

				echo '<input type="text" name="property-id" class="search-text" '.value('Search by Property ID number...').' />';

				echo '<input type="submit" name="search-property" class="search-button" value="Search" onclick="'."$('#p').show();".'" />';

				echo '</form>';

					

				echo '<form action="" method="post" id="page-search-medium">';

				echo '<input type="text" name="transaction-id" class="search-text" '.value('Search by Transaction ID number...').' />';

				echo '<img src="/f/question-mark.gif" onmouseover="'."$(this).parent('form').find('div.details').show();".'" onmouseout="'."$(this).parent('form').find('div.details').hide();".'" />';

				echo '<input type="submit" name="search-transaction" class="search-button" value="SUBMIT" onclick="'."$('#p').show();".'" />';

				echo '<div class="details r4">The Transaction ID number allows you to check in real-time on a secured page the progress on your purchase.</div>';

				echo '</form>';

			echo '<br /><br /><br /></div>';

		}

		

		$search_tracking_field = '<form action="" method="post" id="search-tracking">';

		$search_tracking_field .= '<input type="text" name="search-text" class="search-text" '.value('Type your Transaction ID number...').' />';

		$search_tracking_field .= '<img src="/f/question-mark.gif" onmouseover="'."$(this).parent('form').find('div.details').show();".'" onmouseout="'."$(this).parent('form').find('div.details').hide();".'" />';

		$search_tracking_field .= '<input type="submit" name="search-submit" class="search-button" value="SUBMIT" onclick="'."$('#p').show();".'" />';

		$search_tracking_field .= '<div class="details r4">The Transaction ID number allows you to check in real-time on a secured page the progress on your purchase.</div>';

		$search_tracking_field .= '</form>';

		

		$p['page_description_left'] = str_replace('search_tracking_field',$search_tracking_field,$p['page_description_left']);

				

		echo '<table cellspacing="0" cellpadding="0" id="page" class="r10">';

		echo '<tr>';

			echo '<td valign="top" class="left">';

				$i = 0;

				foreach(preg_split("/((\r?\n)|(\r\n?))/", $s['s_links']) as $line)

				{

					$i++;

					if(!empty($line))

					{

						if(mb_substr($line,0,4) == '<h6>')

						{

							if($i != 1) {$br = '<br />';} else {$br = '';}

							echo str_replace('<h6>',$br.'<h6 class="r5">',$line);

						}

						else

						{

							echo '<a href="../'.strtolower(str_replace(' ','-',$line)).'/">'.$line.'</a>';

						}

					}

				}

			echo '</td>';

			echo '<td valign="top" class="right">';

				echo '<h1 class="r5">'.$p['page_name'].'</h1>';

				if(!empty($p['page_image']) && file_exists(str_replace('../','',$p['page_image'])))

				{

					echo '<div class="page_image none r7" style="background:#fff url('.$p['page_image'].') no-repeat bottom center"></div>';

				}

				

				if($url == 'contact-us')

				{

					echo '<form action="" method="post" class="contact">';

					echo '<b style="display:block; margin:10px 0px;">Please leave your information so we can get back to you:</b>';

					echo '<p>Full Name <span>*</span></p>';

					echo '<input type="text" name="contact_name" />';

					echo '<p>Email <span>*</span></p>';

					echo '<input type="text" name="contact_email" />';

					echo '<p>Phone <span>*</span></p>';

					echo '<input type="text" name="contact_phone" />';

					echo '<p>Category </p>';

					echo '<select name="contact_category">';

					echo '<option selected="" value="">Choose</option>';

					echo '<option value="Rentals">Rentals</option>';

					echo '<option value="Sales">Sales</option>';

					echo '<option value="Finding a Property">Finding a Property</option>';

					echo '<option value="Finding a Real Estate Office or Agent">Finding a Real Estate Office or Agent</option>';

					echo '<option value="Selling a Property">Selling a Property</option>';

					echo '<option value="Careers or Classes">Careers or Classes</option>';

					echo '<option value="Relocation Assistance">Relocation Assistance</option>';

					echo '<option value="International Assistance">International Assistance</option>';

					echo '<option value="Promotions or Contests">Promotions or Contests</option>';

					echo '<option value="Technical Assistance">Technical Assistance</option>';

					echo '<option value="Web site Feedback">Web site Feedback</option>';

					echo '<option value="Other">Other</option>';

					echo '</select>';

					echo '<p>Subject <span>*</span></p>';

					echo '<input type="text" name="contact_subject" />';

					echo '<p>Questions or comments</p>';

					echo '<textarea name="contact_message"></textarea><br/>';

					echo '<label><input type="checkbox" class="inherit" name="contact_newsletter" />&nbsp;&nbsp;&nbsp; Yes, I would like to receive e-mail from '.$s['s_website_name'].'</label>';

					echo '<p>Required Fields <span>*</span> <input type="submit" name="contact_send" value="Submit" class="inherit submit right br6" /></p>';

					echo '<br /><br /><br /></form>';

					echo '<div style="width:50%; padding:5px; vertical-align:top;">';

					echo replace_settings($p['page_description_left']);

					echo '</div>';

					if($domain != 'localhost') { echo $s['s_map']; }

				}

				else

				{

					echo replace_settings($p['page_description_left']);

				}

				echo '</td>';

			echo '</tr>';

		echo '</table>';

	}

}

